varying vec2 texCoord;

uniform sampler2D smallMap;
uniform sampler2D bigMap;
uniform sampler2D paletteMap;
uniform int cloudtype;

uniform float testvalue;

vec2 iResolution=vec2(1920.0,1080.0);




vec2 fishEye(vec2 fragCoord )
{
	const float zoom = 1.28*0.86;
	vec2 p = (fragCoord.xy/vec2(1920.0,1080.0)-vec2(0.5,0.5))*zoom+vec2(0.5,0.5);// / iResolution.x;
	//const float p2 = 1920.0/1080.0;//iResolution.x / iResolution.y;
	//vec2 m = vec2(0.5, 0.5 / p2);
	vec2 m = vec2(0.5, 0.5);

  const float distortion = 2.0 * -4.0 * 0.8 * 0.2;
  float e = exp(distortion);
  const float radius = 1.0;
  float k0 = e / (e - 1.0) * radius;
  float k1 = distortion / radius;

  float dx = p.x - m.x;
  float dy = p.y - m.y;
  float distance = sqrt(dx * dx + dy * dy);

    // too far away ? don't apply anything
    if (distance >= radius)
      return p;

    float k = k0 * (1.0 - exp(-distance * k1)) / distance * 0.75 + 0.25;
    vec2 uv = vec2( m.x + dx * k, m.y + dy * k);

	return uv;
}




void main (void)
{
    vec3 pos;
    vec2 fragCoord=gl_FragCoord.xy;

    vec2 uv = fragCoord.xy/iResolution.xy;
	vec2 p = uv*2.0-1.0;
	p.x*=(iResolution.x/iResolution.y);
    vec2 texCoord2=fishEye(fragCoord);
	//vec2 texCoord2 = (fragCoord.xy/vec2(1920.0,1080.0));
	//texCoord2=uv;







    vec4 blur;
	//if (cloudtype!=1)
	{
		blur=vec4(0,0,0,0);
		
		float bxsize;
		float bxstep;
		float bysize;
		float bystep;
		float divider;

		const float size=4.0;//20.0

		if (cloudtype==2||cloudtype==0||cloudtype==3||cloudtype==1){
			bxsize=1.0/1920.0*size*1.0;
			bxstep=1.0/1920.0*1.0*1.0;
			bysize=1.0/1080.0*size*1.0;
			bystep=1.0/1080.0*1.0*1.0;
			divider=size*2.0*size*2.0/(1.0*1.0)*1.5;// *testvalue;
		} 
	/*	
		else {
			bxsize=1.0/1920.0*1.0*1.0;
			bxstep=1.0/1920.0*1.0*1.0;
			bysize=1.0/1080.0*1.0*1.0;
			bystep=1.0/1080.0*1.0*1.0;
			divider=1.0*2.0*1.0*2.0/(1.0*1.0)*1.5;
		}
	*/
		if (cloudtype==2||cloudtype==0||cloudtype==3||cloudtype==1)
		{
			for (float x=-bxsize; x<bxsize; x+=bxstep){
				for (float y=-bysize; y<bysize; y+=bystep){
		
					blur+=texture2D(smallMap, clamp(texCoord2+vec2(x,y),1.0/1080.0,1.0-1.0/1080.0));
			
				}
			}
			blur/=divider*0.9;
		}
		//else blur=texture2D(smallMap, texCoord2);

		/*
		float b1=pow(blur.x,1.015+(1.0-0.985));
		float b2=pow(blur.y,1.015+(1.0-0.980));
		float b3=pow(blur.z,1.015+(1.0-0.975));
		float b4=blur.a;
		blur=vec4(b1,b2,b3,b4);
		*/
	}




    
    vec4 floor_ =texture2D(bigMap, texCoord2);
	vec4 cloud_;
//if (cloudtype==1) cloud_=texture2D(smallMap, texCoord2); else
	cloud_=blur;
    float a=(1.0-clamp(cloud_.a,0.0,1.0)/1.07);// /1.1;
    //a=pow(a,0.3);
    
    vec3 res;
    if (cloudtype==2){
        //res=cloud_.rgb*a+floor_.rgb*(1.0-a*0.4);
        //res=cloud_.rgb*a+floor_.rgb*(1.0-a);
		vec4 cloud_2=cloud_;
		///cloud_2.g*=1.074;
		float gray=(cloud_2.r+cloud_2.g+cloud_2.b)/3.0;
		cloud_2.rgb=gray;
		///cloud_2=texture2D(paletteMap,vec2(gray,0));
        res=cloud_2.rgb*(1.0-a)+floor_.rgb*(a);
	}
	else if (cloudtype==3){
		a=pow(a,3.0);
        res=cloud_.rgb*(1.0-a)+floor_.rgb*(a);
	}
    else if (cloudtype==1){
			float x=(cloud_.r+cloud_.g+cloud_.b)/3.0;
			vec4 monocloud=vec4(x,x,x,1);
			cloud_=mix(cloud_,monocloud,0.3);

			const float powv=1.6;
			cloud_.r=pow(cloud_.r+0.0025,powv);
			cloud_.g=pow(cloud_.g+0.05,powv);
			cloud_.b=pow(cloud_.b+0.15,powv);
			const float mult=1.3;

			res=cloud_.rgb*mult+floor_.rgb;
		}
		else{
				///cloud_.r=pow(cloud_.r,0.3)*testvalue;
				res=vec3(pow(cloud_.r,1.6))/0.8*0.8+floor_.rgb;
			}
    
    
	gl_FragColor = vec4(res,1.0);
	
}

